﻿//////////////////////////////////////////////
// SchedulerTaskWrapper.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class LogManager ;
}

namespace nkScripts
{
	class Environment ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../../Dll/DllDefines.h"

// nkScripts
#include <NilkinsScripts/Environments/Functions/Function.h>

/// Class ------------------------------------

namespace nkAstraeus::nkTasksWrap
{
	class DLL_ASTRAEUS_EXPORT SchedulerTaskWrapper final
	{
		public :

			// Env
			static void updateEnvironment (nkScripts::Environment* env, LogManager* targetLogManager) ;

			// Callbacks
			// Constructeur, destructeur
			static void* constructor (nkScripts::Environment* env, LogManager* targetLogManager, const nkScripts::DataStack& stack) ;
			static void destructor (void* toDestroy) ;
			// Getters
			static nkScripts::OutputValue getInputBinaryData (void* data) ;
			static nkScripts::OutputValue getOutputBinaryData (void* data) ;
			// Setters
			static void setWorkFunc (const nkScripts::DataStack& stack) ;
			static void setInitScript (const nkScripts::DataStack& stack) ;
			static void setInputBinaryData (const nkScripts::DataStack& stack) ;
			static void setOutputBinaryData (const nkScripts::DataStack& stack) ;
			// UserData
			static nkScripts::OutputValue addInputUserData (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue addOutputUserData (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getInputUserData (const nkScripts::DataStack& stack) ;
			static nkScripts::OutputValue getOutputUserData (const nkScripts::DataStack& stack) ;
	} ;
}